/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback.DelegatingContextView;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.DefaultQueryParametersTagProvider;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.QueryContext;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.QueryObservationConvention;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.QueryParametersTagProvider;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.R2dbcObservationDocumentation;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.net.URI;
import java.net.URISyntaxException;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ObservationProxyExecutionListener
implements ProxyExecutionListener {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ObservationProxyExecutionListener.class);
    private final ConnectionFactory connectionFactory;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final String remoteServiceAddress;
    private boolean includeParameterValues;
    private QueryParametersTagProvider queryParametersTagProvider = new DefaultQueryParametersTagProvider();
    private QueryObservationConvention queryObservationConvention = new QueryObservationConvention(){};

    public ObservationProxyExecutionListener(ObservationRegistry observationRegistry, ConnectionFactory connectionFactory, @Nullable String connectionUrl) {
        this.observationRegistry = observationRegistry;
        this.connectionFactory = connectionFactory;
        this.remoteServiceAddress = connectionUrl != null ? this.parseR2dbcConnectionUrl(connectionUrl) : null;
    }

    public ObservationProxyExecutionListener(ObservationRegistry observationRegistry, ConnectionFactory connectionFactory, @Nullable String host, @Nullable Integer port) {
        this.observationRegistry = observationRegistry;
        this.connectionFactory = connectionFactory;
        this.remoteServiceAddress = this.buildRemoteServiceAddress(host, port);
    }

    @Nullable
    private String parseR2dbcConnectionUrl(String connectionUrl) {
        ConnectionFactoryOptions options = ConnectionFactoryOptions.parse((CharSequence)connectionUrl);
        String host = (String)options.getValue(ConnectionFactoryOptions.HOST);
        Integer portNumber = (Integer)options.getValue(ConnectionFactoryOptions.PORT);
        return this.buildRemoteServiceAddress(host, portNumber);
    }

    @Nullable
    private String buildRemoteServiceAddress(@Nullable String host, @Nullable Integer portNumber) {
        if (host == null) {
            return null;
        }
        int port = portNumber != null ? portNumber : -1;
        try {
            URI uri = new URI(null, null, host, port, null, null, null);
            return uri.toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public void beforeQuery(QueryExecutionInfo executionInfo) {
        if (this.observationRegistry.isNoop()) {
            return;
        }
        Observation parentObservation = (Observation)((ContextView)executionInfo.getValueStore().getOrDefault(ContextView.class, new DelegatingContextView((ContextView)Context.empty()))).getOrDefault((Object)"micrometer.observation", (Object)this.observationRegistry.getCurrentObservation());
        if (parentObservation == null && log.isDebugEnabled()) {
            log.debug("Parent observation not present.");
        }
        String name = this.connectionFactory.getMetadata().getName();
        Observation observation = this.clientObservation(parentObservation, executionInfo, name);
        if (log.isDebugEnabled()) {
            log.debug("Created a new child observation before query [" + observation + "]");
        }
        this.tagQueries(executionInfo, (QueryContext)observation.getContext());
        executionInfo.getValueStore().put(Observation.class, observation);
    }

    private Observation clientObservation(@Nullable Observation parentObservation, QueryExecutionInfo executionInfo, String name) {
        QueryContext context = new QueryContext();
        context.setRemoteServiceName(name);
        context.setRemoteServiceAddress(this.remoteServiceAddress);
        context.setConnectionName(name);
        context.setThreadName(executionInfo.getThreadName());
        Observation observation = R2dbcObservationDocumentation.R2DBC_QUERY_OBSERVATION.observation(this.observationRegistry, () -> context).observationConvention((ObservationConvention)this.queryObservationConvention).parentObservation(parentObservation);
        return observation.start();
    }

    private void tagQueries(QueryExecutionInfo executionInfo, QueryContext context) {
        int i = 0;
        for (QueryInfo queryInfo : executionInfo.getQueries()) {
            context.getQueries().add(queryInfo.getQuery());
            if (this.includeParameterValues) {
                String params = this.queryParametersTagProvider.getTagValue(queryInfo.getBindingsList());
                context.getParams().add(params);
            }
            ++i;
        }
    }

    @Override
    public void afterQuery(QueryExecutionInfo executionInfo) {
        Observation observation = executionInfo.getValueStore().get(Observation.class, Observation.class);
        if (observation != null) {
            Throwable throwable;
            if (log.isDebugEnabled()) {
                log.debug("Continued the child observation in after query [" + observation + "]");
            }
            if ((throwable = executionInfo.getThrowable()) != null) {
                observation.error(throwable);
            }
            observation.stop();
        }
    }

    @Override
    public void eachQueryResult(QueryExecutionInfo executionInfo) {
        Observation observation = executionInfo.getValueStore().get(Observation.class, Observation.class);
        if (observation != null) {
            if (log.isDebugEnabled()) {
                log.debug("Marking after query result for observation [" + observation + "]");
            }
            observation.event((Observation.Event)R2dbcObservationDocumentation.Events.QUERY_RESULT);
        }
    }

    public void setIncludeParameterValues(boolean includeParameterValues) {
        this.includeParameterValues = includeParameterValues;
    }

    public void setQueryParametersTagProvider(QueryParametersTagProvider queryParametersTagProvider) {
        this.queryParametersTagProvider = queryParametersTagProvider;
    }

    public void setQueryObservationConvention(QueryObservationConvention queryObservationConvention) {
        this.queryObservationConvention = queryObservationConvention;
    }
}

