/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.test;

import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.MethodExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ProxyEventType;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ValueStore;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;

public final class MockMethodExecutionInfo
implements MethodExecutionInfo {
    private final Object target;
    private final Method method;
    private final Object[] methodArgs;
    private final Object result;
    private final Throwable thrown;
    private final ConnectionInfo connectionInfo;
    private final Duration executeDuration;
    private final String threadName;
    private final long threadId;
    private final ProxyEventType proxyEventType;
    private final ValueStore valueStore;

    public static Builder builder() {
        return new Builder();
    }

    public static MockMethodExecutionInfo empty() {
        return MockMethodExecutionInfo.builder().build();
    }

    private MockMethodExecutionInfo(Builder builder) {
        this.target = builder.target;
        this.method = builder.method;
        this.methodArgs = builder.methodArgs;
        this.result = builder.result;
        this.thrown = builder.thrown;
        this.connectionInfo = builder.connectionInfo;
        this.executeDuration = builder.executeDuration;
        this.threadName = builder.threadName;
        this.threadId = builder.threadId;
        this.proxyEventType = builder.proxyEventType;
        this.valueStore = builder.valueStore;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public Duration getExecuteDuration() {
        return this.executeDuration;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public ProxyEventType getProxyEventType() {
        return this.proxyEventType;
    }

    @Override
    public ValueStore getValueStore() {
        return this.valueStore;
    }

    public static final class Builder {
        private Object target;
        private Method method;
        private Object[] methodArgs;
        private Object result;
        private Throwable thrown;
        private ConnectionInfo connectionInfo;
        private Duration executeDuration;
        private String threadName;
        private long threadId;
        private ProxyEventType proxyEventType;
        private ValueStore valueStore = ValueStore.create();

        private Builder() {
        }

        public Builder target(Object target) {
            this.target = target;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder methodArgs(Object[] methodArgs) {
            this.methodArgs = methodArgs;
            return this;
        }

        public Builder result(Object result) {
            this.result = result;
            return this;
        }

        public Builder setThrown(Throwable thrown) {
            this.thrown = thrown;
            return this;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder executeDuration(Duration executeDuration) {
            this.executeDuration = executeDuration;
            return this;
        }

        public Builder threadName(String threadName) {
            this.threadName = threadName;
            return this;
        }

        public Builder threadId(long threadId) {
            this.threadId = threadId;
            return this;
        }

        public Builder proxyEventType(ProxyEventType proxyEventType) {
            this.proxyEventType = proxyEventType;
            return this;
        }

        public Builder valueStore(ValueStore valueStore) {
            this.valueStore = valueStore;
            return this;
        }

        public Builder customValue(Object key, Object value) {
            this.valueStore.put(key, value);
            return this;
        }

        public Builder customValues(Map<Object, Object> values) {
            this.valueStore.putAll(values);
            return this;
        }

        public MockMethodExecutionInfo build() {
            return new MockMethodExecutionInfo(this);
        }
    }
}

