/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.jdbc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.InstrumentationConfigUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import javax.sql.DataSource;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

final class DataSourcePostProcessor
implements BeanPostProcessor,
Ordered {
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;
    private final ObjectProvider<ConfigProperties> configPropertiesProvider;

    DataSourcePostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
        this.configPropertiesProvider = configPropertiesProvider;
    }

    @CanIgnoreReturnValue
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource && !ScopedProxyUtils.isScopedTarget((String)beanName)) {
            DataSource dataSource = (DataSource)bean;
            return JdbcTelemetry.builder((OpenTelemetry)((OpenTelemetry)this.openTelemetryProvider.getObject())).setStatementSanitizationEnabled(InstrumentationConfigUtil.isStatementSanitizationEnabled((ConfigProperties)this.configPropertiesProvider.getObject(), "otel.instrumentation.jdbc.statement-sanitizer.enabled")).build().wrap(dataSource);
        }
        return bean;
    }

    public int getOrder() {
        return 2147483627;
    }
}

