/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;

class LogbackAppenderInstaller {
    static void install(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Optional<OpenTelemetryAppender> existingOpenTelemetryAppender = LogbackAppenderInstaller.findOpenTelemetryAppender();
        if (existingOpenTelemetryAppender.isPresent()) {
            LogbackAppenderInstaller.reInitializeOpenTelemetryAppender(existingOpenTelemetryAppender, applicationEnvironmentPreparedEvent);
        } else if (LogbackAppenderInstaller.isLogbackAppenderAddable(applicationEnvironmentPreparedEvent)) {
            LogbackAppenderInstaller.addOpenTelemetryAppender(applicationEnvironmentPreparedEvent);
        }
    }

    private static boolean isLogbackAppenderAddable(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Boolean otelSdkDisableProperty = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.sdk.disabled");
        Boolean logbackInstrumentationEnabledProperty = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.enabled");
        return otelSdkDisableProperty == null || otelSdkDisableProperty == false || logbackInstrumentationEnabledProperty == null || logbackInstrumentationEnabledProperty != false;
    }

    private static void reInitializeOpenTelemetryAppender(Optional<OpenTelemetryAppender> existingOpenTelemetryAppender, ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        OpenTelemetryAppender openTelemetryAppender = existingOpenTelemetryAppender.get();
        openTelemetryAppender.stop();
        LogbackAppenderInstaller.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
    }

    private static void addOpenTelemetryAppender(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Logger logger = (Logger)LoggerFactory.getILoggerFactory().getLogger("ROOT");
        OpenTelemetryAppender openTelemetryAppender = new OpenTelemetryAppender();
        LogbackAppenderInstaller.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
        logger.addAppender((Appender)openTelemetryAppender);
    }

    private static void initializeOpenTelemetryAppenderFromProperties(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, OpenTelemetryAppender openTelemetryAppender) {
        String mdcAttributeProperty;
        Boolean loggerContextAttributes;
        Boolean logAttributes;
        Boolean keyValuePairAttributes;
        Boolean markerAttribute;
        Boolean codeAttribute = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-code-attributes");
        if (codeAttribute != null) {
            openTelemetryAppender.setCaptureCodeAttributes(codeAttribute.booleanValue());
        }
        if ((markerAttribute = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-marker-attribute")) != null) {
            openTelemetryAppender.setCaptureMarkerAttribute(markerAttribute.booleanValue());
        }
        if ((keyValuePairAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-key-value-pair-attributes")) != null) {
            openTelemetryAppender.setCaptureKeyValuePairAttributes(keyValuePairAttributes.booleanValue());
        }
        if ((logAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental-log-attributes")) != null) {
            openTelemetryAppender.setCaptureExperimentalAttributes(logAttributes.booleanValue());
        }
        if ((loggerContextAttributes = LogbackAppenderInstaller.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-logger-context-attributes")) != null) {
            openTelemetryAppender.setCaptureLoggerContext(loggerContextAttributes.booleanValue());
        }
        if ((mdcAttributeProperty = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.logback-appender.experimental.capture-mdc-attributes", String.class)) != null) {
            openTelemetryAppender.setCaptureMdcAttributes(mdcAttributeProperty);
        }
    }

    private static Boolean evaluateBooleanProperty(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, String property) {
        return (Boolean)applicationEnvironmentPreparedEvent.getEnvironment().getProperty(property, Boolean.class);
    }

    private static Optional<OpenTelemetryAppender> findOpenTelemetryAppender() {
        ILoggerFactory loggerFactorySpi = LoggerFactory.getILoggerFactory();
        if (!(loggerFactorySpi instanceof LoggerContext)) {
            return Optional.empty();
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactorySpi;
        for (Logger logger : loggerContext.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                if (!(appender instanceof OpenTelemetryAppender)) continue;
                OpenTelemetryAppender openTelemetryAppender = (OpenTelemetryAppender)appender;
                return Optional.of(openTelemetryAppender);
            }
        }
        return Optional.empty();
    }

    private LogbackAppenderInstaller() {
    }
}

