/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.InstrumentedBatchInterceptor;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.InstrumentedRecordInterceptor;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.SpringKafkaTelemetryBuilder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.kafka.listener.RecordInterceptor;

public final class SpringKafkaTelemetry {
    private final Instrumenter<ConsumerRecord<?, ?>, Void> processInstrumenter;
    private final Instrumenter<ConsumerRecords<?, ?>, Void> batchProcessInstrumenter;

    public static SpringKafkaTelemetry create(OpenTelemetry openTelemetry) {
        return SpringKafkaTelemetry.builder(openTelemetry).build();
    }

    public static SpringKafkaTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringKafkaTelemetryBuilder(openTelemetry);
    }

    SpringKafkaTelemetry(Instrumenter<ConsumerRecord<?, ?>, Void> processInstrumenter, Instrumenter<ConsumerRecords<?, ?>, Void> batchProcessInstrumenter) {
        this.processInstrumenter = processInstrumenter;
        this.batchProcessInstrumenter = batchProcessInstrumenter;
    }

    public <K, V> RecordInterceptor<K, V> createRecordInterceptor() {
        return this.createRecordInterceptor(null);
    }

    public <K, V> RecordInterceptor<K, V> createRecordInterceptor(RecordInterceptor<K, V> decoratedInterceptor) {
        return new InstrumentedRecordInterceptor<K, V>(this.processInstrumenter, decoratedInterceptor);
    }

    public <K, V> BatchInterceptor<K, V> createBatchInterceptor() {
        return this.createBatchInterceptor(null);
    }

    public <K, V> BatchInterceptor<K, V> createBatchInterceptor(BatchInterceptor<K, V> decoratedInterceptor) {
        return new InstrumentedBatchInterceptor<K, V>(this.batchProcessInstrumenter, decoratedInterceptor);
    }
}

