/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaInstrumenterFactory;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.SpringKafkaErrorCauseExtractor;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.SpringKafkaTelemetry;
import java.util.Collections;
import java.util.List;

public final class SpringKafkaTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-kafka-2.7";
    private final OpenTelemetry openTelemetry;
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean messagingReceiveInstrumentationEnabled = false;

    SpringKafkaTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringKafkaTelemetryBuilder setCapturedHeaders(List<String> capturedHeaders) {
        this.capturedHeaders = capturedHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringKafkaTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public SpringKafkaTelemetryBuilder setPropagationEnabled(boolean propagationEnabled) {
        return this;
    }

    @CanIgnoreReturnValue
    public SpringKafkaTelemetryBuilder setMessagingReceiveInstrumentationEnabled(boolean messagingReceiveInstrumentationEnabled) {
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        return this;
    }

    public SpringKafkaTelemetry build() {
        KafkaInstrumenterFactory factory = new KafkaInstrumenterFactory(this.openTelemetry, INSTRUMENTATION_NAME).setCapturedHeaders(this.capturedHeaders).setCaptureExperimentalSpanAttributes(this.captureExperimentalSpanAttributes).setMessagingReceiveInstrumentationEnabled(this.messagingReceiveInstrumentationEnabled).setErrorCauseExtractor((ErrorCauseExtractor)SpringKafkaErrorCauseExtractor.INSTANCE);
        return new SpringKafkaTelemetry(factory.createConsumerProcessInstrumenter(), factory.createBatchProcessInstrumenter());
    }
}

