/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.State;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;

final class InstrumentedBatchInterceptor<K, V>
implements BatchInterceptor<K, V> {
    private static final VirtualField<ConsumerRecords<?, ?>, Context> receiveContextField = VirtualField.find(ConsumerRecords.class, Context.class);
    private static final VirtualField<ConsumerRecords<?, ?>, State<ConsumerRecords<?, ?>>> stateField = VirtualField.find(ConsumerRecords.class, State.class);
    private final Instrumenter<ConsumerRecords<?, ?>, Void> batchProcessInstrumenter;
    @Nullable
    private final BatchInterceptor<K, V> decorated;

    InstrumentedBatchInterceptor(Instrumenter<ConsumerRecords<?, ?>, Void> batchProcessInstrumenter, @Nullable BatchInterceptor<K, V> decorated) {
        this.batchProcessInstrumenter = batchProcessInstrumenter;
        this.decorated = decorated;
    }

    public ConsumerRecords<K, V> intercept(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        Context parentContext = this.getParentContext(records);
        if (this.batchProcessInstrumenter.shouldStart(parentContext, records)) {
            Context context = this.batchProcessInstrumenter.start(parentContext, records);
            Scope scope = context.makeCurrent();
            stateField.set((Object)records, State.create(records, context, scope));
        }
        return this.decorated == null ? records : this.decorated.intercept(records, consumer);
    }

    private Context getParentContext(ConsumerRecords<K, V> records) {
        Context receiveContext = (Context)receiveContextField.get(records);
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        this.end(records, null);
        if (this.decorated != null) {
            this.decorated.success(records, consumer);
        }
    }

    public void failure(ConsumerRecords<K, V> records, Exception exception, Consumer<K, V> consumer) {
        this.end(records, exception);
        if (this.decorated != null) {
            this.decorated.failure(records, exception, consumer);
        }
    }

    private void end(ConsumerRecords<K, V> records, @Nullable Throwable error) {
        State state = (State)stateField.get(records);
        stateField.set(records, null);
        if (state != null) {
            state.scope().close();
            this.batchProcessInstrumenter.end(state.context(), (Object)((ConsumerRecords)state.request()), null, error);
        }
    }
}

