/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.State;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.RecordInterceptor;

final class InstrumentedRecordInterceptor<K, V>
implements RecordInterceptor<K, V> {
    private static final VirtualField<ConsumerRecord<?, ?>, Context> receiveContextField = VirtualField.find(ConsumerRecord.class, Context.class);
    private static final VirtualField<ConsumerRecord<?, ?>, State<ConsumerRecord<?, ?>>> stateField = VirtualField.find(ConsumerRecord.class, State.class);
    private final Instrumenter<ConsumerRecord<?, ?>, Void> processInstrumenter;
    @Nullable
    private final RecordInterceptor<K, V> decorated;

    InstrumentedRecordInterceptor(Instrumenter<ConsumerRecord<?, ?>, Void> processInstrumenter, @Nullable RecordInterceptor<K, V> decorated) {
        this.processInstrumenter = processInstrumenter;
        this.decorated = decorated;
    }

    @NoMuzzle
    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record) {
        this.start(record);
        return this.decorated == null ? record : this.decorated.intercept(record);
    }

    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.start(record);
        return this.decorated == null ? record : this.decorated.intercept(record, consumer);
    }

    private void start(ConsumerRecord<K, V> record) {
        Context parentContext = this.getParentContext(record);
        if (this.processInstrumenter.shouldStart(parentContext, record)) {
            Context context = this.processInstrumenter.start(parentContext, record);
            Scope scope = context.makeCurrent();
            stateField.set(record, State.create(record, context, scope));
        }
    }

    private Context getParentContext(ConsumerRecord<K, V> records) {
        Context receiveContext = (Context)receiveContextField.get(records);
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.end(record, null);
        if (this.decorated != null) {
            this.decorated.success(record, consumer);
        }
    }

    public void failure(ConsumerRecord<K, V> record, Exception exception, Consumer<K, V> consumer) {
        this.end(record, exception);
        if (this.decorated != null) {
            this.decorated.failure(record, exception, consumer);
        }
    }

    private void end(ConsumerRecord<K, V> record, @Nullable Throwable error) {
        State state = (State)stateField.get(record);
        stateField.set(record, null);
        if (state != null) {
            state.scope().close();
            this.processInstrumenter.end(state.context(), (Object)((ConsumerRecord)state.request()), null, error);
        }
    }
}

