/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.kafka.v2_7;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContextUtil;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveRequest;
import io.opentelemetry.instrumentation.spring.kafka.v2_7.State;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;

final class InstrumentedBatchInterceptor<K, V>
implements BatchInterceptor<K, V> {
    private static final VirtualField<ConsumerRecords<?, ?>, State<KafkaReceiveRequest>> stateField = VirtualField.find(ConsumerRecords.class, State.class);
    private static final ThreadLocal<WeakReference<ConsumerRecords<?, ?>>> lastProcessed = new ThreadLocal();
    private final Instrumenter<KafkaReceiveRequest, Void> batchProcessInstrumenter;
    @Nullable
    private final BatchInterceptor<K, V> decorated;

    InstrumentedBatchInterceptor(Instrumenter<KafkaReceiveRequest, Void> batchProcessInstrumenter, @Nullable BatchInterceptor<K, V> decorated) {
        this.batchProcessInstrumenter = batchProcessInstrumenter;
        this.decorated = decorated;
    }

    public ConsumerRecords<K, V> intercept(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        KafkaReceiveRequest request;
        Context parentContext = InstrumentedBatchInterceptor.getParentContext(records);
        if (this.batchProcessInstrumenter.shouldStart(parentContext, (Object)(request = KafkaReceiveRequest.create(records, consumer))) && !InstrumentedBatchInterceptor.skipProcessing(records)) {
            Context context = this.batchProcessInstrumenter.start(parentContext, (Object)request);
            Scope scope = context.makeCurrent();
            stateField.set((Object)records, State.create(request, context, scope));
        }
        return this.decorated == null ? records : this.decorated.intercept(records, consumer);
    }

    private static boolean skipProcessing(ConsumerRecords<?, ?> records) {
        WeakReference<ConsumerRecords<?, ?>> reference = lastProcessed.get();
        return reference != null && reference.get() == records;
    }

    private static Context getParentContext(ConsumerRecords<?, ?> records) {
        KafkaConsumerContext consumerContext = KafkaConsumerContextUtil.get(records);
        Context receiveContext = consumerContext.getContext();
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        this.end(records, null);
        if (this.decorated != null) {
            this.decorated.success(records, consumer);
        }
    }

    public void failure(ConsumerRecords<K, V> records, Exception exception, Consumer<K, V> consumer) {
        this.end(records, exception);
        if (this.decorated != null) {
            this.decorated.failure(records, exception, consumer);
        }
    }

    private void end(ConsumerRecords<K, V> records, @Nullable Throwable error) {
        State state = (State)stateField.get(records);
        stateField.set(records, null);
        if (state != null) {
            KafkaReceiveRequest request = (KafkaReceiveRequest)state.request();
            state.scope().close();
            this.batchProcessInstrumenter.end(state.context(), (Object)request, null, error);
            lastProcessed.set(new WeakReference<ConsumerRecords<K, V>>(records));
        }
    }

    @NoMuzzle
    public void setupThreadState(Consumer<?, ?> consumer) {
        if (this.decorated != null) {
            this.decorated.setupThreadState(consumer);
        }
    }

    @NoMuzzle
    public void clearThreadState(Consumer<?, ?> consumer) {
        if (this.decorated != null) {
            this.decorated.clearThreadState(consumer);
        }
    }
}

