/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

enum SpringWebHttpAttributesGetter implements HttpClientAttributesGetter<HttpRequest, ClientHttpResponse>
{
    INSTANCE;


    public String method(HttpRequest httpRequest) {
        return httpRequest.getMethod().name();
    }

    @Nullable
    public String url(HttpRequest httpRequest) {
        return httpRequest.getURI().toString();
    }

    public List<String> requestHeader(HttpRequest httpRequest, String name) {
        return (List)httpRequest.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public String flavor(HttpRequest httpRequest, @Nullable ClientHttpResponse clientHttpResponse) {
        return null;
    }

    public Integer statusCode(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse, @Nullable Throwable error) {
        try {
            return clientHttpResponse.getStatusCode().value();
        }
        catch (IOException e) {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
    }

    public List<String> responseHeader(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse, String name) {
        return (List)clientHttpResponse.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }
}

