/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.web.RestTemplateInterceptor;
import io.opentelemetry.instrumentation.spring.web.SpringWebTelemetryBuilder;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTelemetry {
    private final Instrumenter<HttpRequest, ClientHttpResponse> instrumenter;

    public static SpringWebTelemetry create(OpenTelemetry openTelemetry) {
        return SpringWebTelemetry.builder(openTelemetry).build();
    }

    public static SpringWebTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringWebTelemetryBuilder(openTelemetry);
    }

    SpringWebTelemetry(Instrumenter<HttpRequest, ClientHttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public ClientHttpRequestInterceptor newInterceptor() {
        return new RestTemplateInterceptor(this.instrumenter);
    }
}

