/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web.v3_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.web.v3_1.HttpRequestSetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebTelemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-web-3.1";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpRequest, ClientHttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpRequest, ClientHttpResponse>>();
    private final HttpClientAttributesExtractorBuilder<HttpRequest, ClientHttpResponse> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)SpringWebHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<HttpRequest> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)SpringWebHttpAttributesGetter.INSTANCE);
    private boolean emitExperimentalHttpClientMetrics = false;
    @Nullable
    private Function<SpanNameExtractor<HttpRequest>, ? extends SpanNameExtractor<? super HttpRequest>> spanNameExtractorTransformer;

    SpringWebTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpRequest, ClientHttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpRequest>, ? extends SpanNameExtractor<? super HttpRequest>> spanNameExtractor) {
        this.spanNameExtractorTransformer = spanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    public SpringWebTelemetry build() {
        SpanNameExtractor<? super HttpRequest> originalSpanNameExtractor;
        SpringWebHttpAttributesGetter httpAttributesGetter = SpringWebHttpAttributesGetter.INSTANCE;
        SpanNameExtractor<? super HttpRequest> spanNameExtractor = originalSpanNameExtractor = this.httpSpanNameExtractorBuilder.build();
        if (this.spanNameExtractorTransformer != null) {
            spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<HttpRequest>)originalSpanNameExtractor);
        }
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        Instrumenter instrumenter = builder.buildClientInstrumenter((TextMapSetter)HttpRequestSetter.INSTANCE);
        return new SpringWebTelemetry((Instrumenter<HttpRequest, ClientHttpResponse>)instrumenter);
    }
}

