/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web;

import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

final class SpringWebHttpAttributesExtractor
extends HttpClientAttributesExtractor<HttpRequest, ClientHttpResponse> {
    SpringWebHttpAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        super(capturedHttpHeaders);
    }

    protected String method(HttpRequest httpRequest) {
        return httpRequest.getMethod().name();
    }

    @Nullable
    protected String url(HttpRequest httpRequest) {
        return httpRequest.getURI().toString();
    }

    protected List<String> requestHeader(HttpRequest httpRequest, String name) {
        return (List)httpRequest.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    protected Long requestContentLength(HttpRequest httpRequest, @Nullable ClientHttpResponse clientHttpResponse) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(HttpRequest httpRequest, @Nullable ClientHttpResponse clientHttpResponse) {
        return null;
    }

    @Nullable
    protected String flavor(HttpRequest httpRequest, @Nullable ClientHttpResponse clientHttpResponse) {
        return null;
    }

    protected Integer statusCode(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse) {
        try {
            return clientHttpResponse.getStatusCode().value();
        }
        catch (IOException e) {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
    }

    @Nullable
    protected Long responseContentLength(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse) {
        return null;
    }

    protected List<String> responseHeader(HttpRequest httpRequest, ClientHttpResponse clientHttpResponse, String name) {
        return (List)clientHttpResponse.getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }
}

