/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.web.RestTemplateInterceptor;
import io.opentelemetry.instrumentation.spring.web.SpringWebTracingBuilder;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTracing {
    private final Instrumenter<HttpRequest, ClientHttpResponse> instrumenter;

    public static SpringWebTracing create(OpenTelemetry openTelemetry) {
        return SpringWebTracing.newBuilder(openTelemetry).build();
    }

    public static SpringWebTracingBuilder newBuilder(OpenTelemetry openTelemetry) {
        return new SpringWebTracingBuilder(openTelemetry);
    }

    SpringWebTracing(Instrumenter<HttpRequest, ClientHttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public ClientHttpRequestInterceptor newInterceptor() {
        return new RestTemplateInterceptor(this.instrumenter);
    }
}

