/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.web.HttpRequestSetter;
import io.opentelemetry.instrumentation.spring.web.SpringWebHttpAttributesExtractor;
import io.opentelemetry.instrumentation.spring.web.SpringWebNetAttributesExtractor;
import io.opentelemetry.instrumentation.spring.web.SpringWebTracing;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTracingBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-web-3.1";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpRequest, ClientHttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpRequest, ClientHttpResponse>>();
    private CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.client((Config)Config.get());

    SpringWebTracingBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public SpringWebTracingBuilder addAttributesExtractor(AttributesExtractor<HttpRequest, ClientHttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public SpringWebTracingBuilder captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public SpringWebTracing build() {
        SpringWebHttpAttributesExtractor httpAttributesExtractor = new SpringWebHttpAttributesExtractor(this.capturedHttpHeaders);
        SpringWebNetAttributesExtractor netAttributesExtractor = new SpringWebNetAttributesExtractor();
        Instrumenter instrumenter = Instrumenter.newBuilder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor)).addAttributesExtractor((AttributesExtractor)httpAttributesExtractor).addAttributesExtractor((AttributesExtractor)netAttributesExtractor).addAttributesExtractors(this.additionalExtractors).addRequestMetrics(HttpClientMetrics.get()).newClientInstrumenter((TextMapSetter)new HttpRequestSetter());
        return new SpringWebTracing((Instrumenter<HttpRequest, ClientHttpResponse>)instrumenter);
    }
}

