/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web.v3_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.HttpRequestSetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebTelemetry;
import io.opentelemetry.instrumentation.spring.web.v3_1.internal.WebTelemetryUtil;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class SpringWebTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-web-3.1";
    private final DefaultHttpClientInstrumenterBuilder<HttpRequest, ClientHttpResponse> builder;

    SpringWebTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = new DefaultHttpClientInstrumenterBuilder(INSTRUMENTATION_NAME, openTelemetry, (HttpClientAttributesGetter)SpringWebHttpAttributesGetter.INSTANCE).setHeaderSetter((TextMapSetter)HttpRequestSetter.INSTANCE);
    }

    private DefaultHttpClientInstrumenterBuilder<HttpRequest, ClientHttpResponse> getBuilder() {
        return this.builder;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super HttpRequest, ? super ClientHttpResponse> attributesExtractor) {
        this.builder.addAttributeExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpRequest>, ? extends SpanNameExtractor<? super HttpRequest>> spanNameExtractorTransformer) {
        this.builder.setSpanNameExtractor(spanNameExtractorTransformer);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.builder.setEmitExperimentalHttpClientMetrics(emitExperimentalHttpClientMetrics);
        return this;
    }

    public SpringWebTelemetry build() {
        return new SpringWebTelemetry((Instrumenter<HttpRequest, ClientHttpResponse>)this.builder.build());
    }

    static {
        WebTelemetryUtil.setBuilderExtractor(SpringWebTelemetryBuilder::getBuilder);
    }
}

