/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxHttpClientTracer;
import org.reactivestreams.Subscription;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.CoreSubscriber;

public final class TraceWebClientSubscriber
implements CoreSubscriber<ClientResponse> {
    final CoreSubscriber<? super ClientResponse> actual;
    final reactor.util.context.Context context;
    private final Context tracingContext;

    public TraceWebClientSubscriber(CoreSubscriber<? super ClientResponse> actual, Context tracingContext) {
        this.actual = actual;
        this.tracingContext = tracingContext;
        this.context = actual.currentContext();
    }

    public void onSubscribe(Subscription subscription) {
        this.actual.onSubscribe(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(ClientResponse response) {
        try (Scope ignored = this.tracingContext.makeCurrent();){
            this.actual.onNext((Object)response);
        }
        finally {
            SpringWebfluxHttpClientTracer.tracer().end(this.tracingContext, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        try (Scope ignored = this.tracingContext.makeCurrent();){
            this.actual.onError(t);
        }
        finally {
            SpringWebfluxHttpClientTracer.tracer().endExceptionally(this.tracingContext, t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.tracingContext.makeCurrent();){
            this.actual.onComplete();
        }
    }

    public reactor.util.context.Context currentContext() {
        return this.context;
    }
}

