/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxHttpClientTracer;
import io.opentelemetry.instrumentation.spring.webflux.client.TraceWebClientSubscriber;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

public class WebClientTracingFilter
implements ExchangeFilterFunction {
    public static void addFilter(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        for (ExchangeFilterFunction filterFunction : exchangeFilterFunctions) {
            if (!(filterFunction instanceof WebClientTracingFilter)) continue;
            return;
        }
        exchangeFilterFunctions.add(0, new WebClientTracingFilter());
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return new MonoWebClientTrace(request, next);
    }

    public static final class MonoWebClientTrace
    extends Mono<ClientResponse> {
        final ExchangeFunction next;
        final ClientRequest request;

        public MonoWebClientTrace(ClientRequest request, ExchangeFunction next) {
            this.next = next;
            this.request = request;
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            Context parentContext = Context.current();
            if (!SpringWebfluxHttpClientTracer.tracer().shouldStartSpan(parentContext)) {
                return;
            }
            ClientRequest.Builder builder = ClientRequest.from((ClientRequest)this.request);
            Context context = SpringWebfluxHttpClientTracer.tracer().startSpan(parentContext, this.request, builder);
            try (Scope ignored = context.makeCurrent();){
                this.next.exchange(builder.build()).doOnCancel(() -> {
                    SpringWebfluxHttpClientTracer.tracer().onCancel(context);
                    SpringWebfluxHttpClientTracer.tracer().end(context);
                }).subscribe((CoreSubscriber)new TraceWebClientSubscriber(subscriber, context));
            }
        }
    }
}

