/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.instrumentation.spring.webflux.client.HttpHeadersInjectAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public class SpringWebfluxHttpClientTracer
extends HttpClientTracer<ClientRequest, ClientRequest.Builder, ClientResponse> {
    private static final SpringWebfluxHttpClientTracer TRACER = new SpringWebfluxHttpClientTracer();
    private static final MethodHandle RAW_STATUS_CODE = SpringWebfluxHttpClientTracer.findRawStatusCode();

    public static SpringWebfluxHttpClientTracer tracer() {
        return TRACER;
    }

    public void onCancel(Context context) {
        if (SpringWebfluxHttpClientTracer.captureExperimentalSpanAttributes()) {
            Span span = Span.fromContext((Context)context);
            span.setAttribute("spring-webflux.event", "cancelled");
            span.setAttribute("spring-webflux.message", "The subscription was cancelled");
        }
    }

    protected String method(ClientRequest httpRequest) {
        return httpRequest.method().name();
    }

    protected URI url(ClientRequest httpRequest) {
        return httpRequest.url();
    }

    protected Integer status(ClientResponse httpResponse) {
        if (RAW_STATUS_CODE != null) {
            try {
                return RAW_STATUS_CODE.invokeExact(httpResponse);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return httpResponse.statusCode().value();
    }

    protected String requestHeader(ClientRequest clientRequest, String name) {
        return clientRequest.headers().getFirst(name);
    }

    protected String responseHeader(ClientResponse clientResponse, String name) {
        List headers = clientResponse.headers().header(name);
        return !headers.isEmpty() ? (String)headers.get(0) : null;
    }

    protected TextMapSetter<ClientRequest.Builder> getSetter() {
        return HttpHeadersInjectAdapter.SETTER;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.spring-webflux-5.0";
    }

    private static MethodHandle findRawStatusCode() {
        try {
            return MethodHandles.publicLookup().findVirtual(ClientResponse.class, "rawStatusCode", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean captureExperimentalSpanAttributes() {
        return Config.get().getBooleanProperty("otel.instrumentation.spring-webflux.experimental-span-attributes", false);
    }
}

