/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

enum SpringWebfluxHttpAttributesGetter implements HttpClientAttributesGetter<ClientRequest, ClientResponse>
{
    INSTANCE;

    private static final MethodHandle RAW_STATUS_CODE;

    private static MethodHandle findRawStatusCode() {
        try {
            return MethodHandles.publicLookup().findVirtual(ClientResponse.class, "rawStatusCode", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public String url(ClientRequest request) {
        return request.url().toString();
    }

    @Nullable
    public String flavor(ClientRequest request, @Nullable ClientResponse response) {
        return null;
    }

    public String method(ClientRequest request) {
        return request.method().name();
    }

    public List<String> requestHeader(ClientRequest request, String name) {
        return (List)request.headers().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public Long requestContentLength(ClientRequest request, @Nullable ClientResponse response) {
        return null;
    }

    @Nullable
    public Long requestContentLengthUncompressed(ClientRequest request, @Nullable ClientResponse response) {
        return null;
    }

    public Integer statusCode(ClientRequest request, ClientResponse response) {
        if (RAW_STATUS_CODE != null) {
            try {
                return RAW_STATUS_CODE.invokeExact(response);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return response.statusCode().value();
    }

    @Nullable
    public Long responseContentLength(ClientRequest request, ClientResponse response) {
        return null;
    }

    @Nullable
    public Long responseContentLengthUncompressed(ClientRequest request, ClientResponse response) {
        return null;
    }

    public List<String> responseHeader(ClientRequest request, ClientResponse response, String name) {
        return response.headers().header(name);
    }

    static {
        RAW_STATUS_CODE = SpringWebfluxHttpAttributesGetter.findRawStatusCode();
    }
}

