/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.client.internal.SpringWebfluxNetAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public final class SpringWebfluxTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<ClientRequest, ClientResponse>> additionalExtractors = new ArrayList<AttributesExtractor<ClientRequest, ClientResponse>>();
    private final HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)SpringWebfluxHttpAttributesGetter.INSTANCE);
    private boolean captureExperimentalSpanAttributes = false;

    SpringWebfluxTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public SpringWebfluxTelemetryBuilder addAttributesExtractor(AttributesExtractor<ClientRequest, ClientResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public SpringWebfluxTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    public SpringWebfluxTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public SpringWebfluxTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    public SpringWebfluxTelemetry build() {
        SpringWebfluxHttpAttributesGetter httpAttributesGetter = SpringWebfluxHttpAttributesGetter.INSTANCE;
        SpringWebfluxNetAttributesGetter netAttributesGetter = new SpringWebfluxNetAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)"io.opentelemetry.spring-webflux-5.0", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)this.httpAttributesExtractorBuilder.build()).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.captureExperimentalSpanAttributes) {
            builder.addAttributesExtractor((AttributesExtractor)new SpringWebfluxExperimentalAttributesExtractor());
        }
        Instrumenter instrumenter = builder.newInstrumenter(SpanKindExtractor.alwaysClient());
        return new SpringWebfluxTelemetry((Instrumenter<ClientRequest, ClientResponse>)instrumenter, this.openTelemetry.getPropagators());
    }
}

