/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import org.reactivestreams.Subscription;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.CoreSubscriber;

final class TraceWebClientSubscriber
implements CoreSubscriber<ClientResponse> {
    private final Instrumenter<ClientRequest, ClientResponse> instrumenter;
    private final ClientRequest request;
    private final CoreSubscriber<? super ClientResponse> actual;
    private final reactor.util.context.Context reactorContext;
    private final Context otelContext;

    TraceWebClientSubscriber(Instrumenter<ClientRequest, ClientResponse> instrumenter, ClientRequest request, CoreSubscriber<? super ClientResponse> actual, Context otelContext) {
        this.instrumenter = instrumenter;
        this.request = request;
        this.actual = actual;
        this.otelContext = otelContext;
        this.reactorContext = actual.currentContext();
    }

    public void onSubscribe(Subscription subscription) {
        this.actual.onSubscribe(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(ClientResponse response) {
        try (Scope ignored = this.otelContext.makeCurrent();){
            this.actual.onNext((Object)response);
        }
        finally {
            this.instrumenter.end(this.otelContext, (Object)this.request, (Object)response, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        try (Scope ignored = this.otelContext.makeCurrent();){
            this.actual.onError(t);
        }
        finally {
            this.instrumenter.end(this.otelContext, (Object)this.request, null, t);
        }
    }

    public void onComplete() {
        try (Scope ignored = this.otelContext.makeCurrent();){
            this.actual.onComplete();
        }
    }

    public reactor.util.context.Context currentContext() {
        return this.reactorContext;
    }
}

