/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.client.StatusCodes;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

enum SpringWebfluxHttpAttributesGetter implements HttpClientAttributesGetter<ClientRequest, ClientResponse>
{
    INSTANCE;


    public String url(ClientRequest request) {
        return request.url().toString();
    }

    @Nullable
    public String flavor(ClientRequest request, @Nullable ClientResponse response) {
        return null;
    }

    public String method(ClientRequest request) {
        return request.method().name();
    }

    public List<String> requestHeader(ClientRequest request, String name) {
        return (List)request.headers().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public Integer statusCode(ClientRequest request, ClientResponse response, @Nullable Throwable error) {
        return StatusCodes.get(response);
    }

    public List<String> responseHeader(ClientRequest request, ClientResponse response, String name) {
        return response.headers().header(name);
    }
}

