/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxTelemetryBuilder;
import io.opentelemetry.instrumentation.spring.webflux.client.WebClientTracingFilter;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;

public final class SpringWebfluxTelemetry {
    private final Instrumenter<ClientRequest, ClientResponse> instrumenter;
    private final ContextPropagators propagators;

    public static SpringWebfluxTelemetry create(OpenTelemetry openTelemetry) {
        return SpringWebfluxTelemetry.builder(openTelemetry).build();
    }

    public static SpringWebfluxTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringWebfluxTelemetryBuilder(openTelemetry);
    }

    SpringWebfluxTelemetry(Instrumenter<ClientRequest, ClientResponse> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public void addClientTracingFilter(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        for (ExchangeFilterFunction filterFunction : exchangeFilterFunctions) {
            if (!(filterFunction instanceof WebClientTracingFilter)) continue;
            return;
        }
        exchangeFilterFunctions.add(new WebClientTracingFilter(this.instrumenter, this.propagators));
    }
}

