/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.client;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientResponse;

final class StatusCodes {
    private static final Logger logger = Logger.getLogger(StatusCodes.class.getName());
    @Nullable
    private static final Function<ClientResponse, Integer> statusCodeFunction = StatusCodes.getStatusCodeFunction();

    @Nullable
    static Integer get(ClientResponse response) {
        if (statusCodeFunction == null) {
            return null;
        }
        return statusCodeFunction.apply(response);
    }

    @Nullable
    private static Function<ClientResponse, Integer> getStatusCodeFunction() {
        Function<ClientResponse, Integer> statusCodeFunction = StatusCodes.getStatusCodeFunction60();
        if (statusCodeFunction != null) {
            return statusCodeFunction;
        }
        statusCodeFunction = StatusCodes.getStatusCodeFunction51();
        if (statusCodeFunction != null) {
            return statusCodeFunction;
        }
        return StatusCodes.getStatusCodeFunction50();
    }

    @Nullable
    private static Function<ClientResponse, Integer> getStatusCodeFunction60() {
        MethodHandle value;
        MethodHandle statusCode;
        try {
            Class<?> httpStatusCodeClass = Class.forName("org.springframework.http.HttpStatusCode");
            statusCode = MethodHandles.publicLookup().findVirtual(ClientResponse.class, "statusCode", MethodType.methodType(httpStatusCodeClass));
            value = MethodHandles.publicLookup().findVirtual(httpStatusCodeClass, "value", MethodType.methodType(Integer.TYPE));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        return response -> {
            try {
                Object httpStatusCode = statusCode.invoke((ClientResponse)response);
                return value.invoke(httpStatusCode);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return null;
            }
        };
    }

    @Nullable
    private static Function<ClientResponse, Integer> getStatusCodeFunction51() {
        MethodHandle rawStatusCode;
        try {
            rawStatusCode = MethodHandles.publicLookup().findVirtual(ClientResponse.class, "rawStatusCode", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        return response -> {
            try {
                return rawStatusCode.invoke((ClientResponse)response);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return null;
            }
        };
    }

    @Nullable
    private static Function<ClientResponse, Integer> getStatusCodeFunction50() {
        MethodHandle value;
        MethodHandle statusCode;
        try {
            statusCode = MethodHandles.publicLookup().findVirtual(ClientResponse.class, "statusCode", MethodType.methodType(HttpStatus.class));
            value = MethodHandles.publicLookup().findVirtual(HttpStatus.class, "value", MethodType.methodType(Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        return response -> {
            try {
                Object httpStatusCode = statusCode.invoke((ClientResponse)response);
                return value.invoke(httpStatusCode);
            }
            catch (Throwable e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return null;
            }
        };
    }

    private StatusCodes() {
    }
}

