/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxServerHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxTextMapGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.ClientInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;

public final class SpringWebfluxTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<ClientRequest, ClientResponse>> clientAdditionalExtractors = new ArrayList<AttributesExtractor<ClientRequest, ClientResponse>>();
    private final List<AttributesExtractor<ServerWebExchange, ServerWebExchange>> serverAdditionalExtractors = new ArrayList<AttributesExtractor<ServerWebExchange, ServerWebExchange>>();
    private final HttpServerAttributesExtractorBuilder<ServerWebExchange, ServerWebExchange> httpServerAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)WebfluxServerHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<ServerWebExchange> httpServerSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpCommonAttributesGetter)WebfluxServerHttpAttributesGetter.INSTANCE);
    private final HttpServerRouteBuilder<ServerWebExchange> httpServerRouteBuilder = HttpServerRoute.builder((HttpServerAttributesGetter)WebfluxServerHttpAttributesGetter.INSTANCE);
    private Consumer<HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse>> clientExtractorConfigurer = builder -> {};
    private Consumer<HttpSpanNameExtractorBuilder<ClientRequest>> clientSpanNameExtractorConfigurer = builder -> {};
    private boolean captureExperimentalSpanAttributes = false;
    private boolean emitExperimentalHttpClientMetrics = false;
    private boolean emitExperimentalHttpServerMetrics = false;

    SpringWebfluxTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder addClientAttributesExtractor(AttributesExtractor<ClientRequest, ClientResponse> attributesExtractor) {
        this.clientAdditionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedClientRequestHeaders(List<String> requestHeaders) {
        this.clientExtractorConfigurer = this.clientExtractorConfigurer.andThen(builder -> builder.setCapturedRequestHeaders(requestHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedClientResponseHeaders(List<String> responseHeaders) {
        this.clientExtractorConfigurer = this.clientExtractorConfigurer.andThen(builder -> builder.setCapturedResponseHeaders(responseHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder addServerAttributesExtractor(AttributesExtractor<ServerWebExchange, ServerWebExchange> attributesExtractor) {
        this.serverAdditionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedServerRequestHeaders(List<String> requestHeaders) {
        this.httpServerAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedServerResponseHeaders(List<String> responseHeaders) {
        this.httpServerAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.clientExtractorConfigurer = this.clientExtractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        this.clientSpanNameExtractorConfigurer = this.clientSpanNameExtractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        this.httpServerAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    public SpringWebfluxTelemetry build() {
        Instrumenter<ClientRequest, ClientResponse> clientInstrumenter = ClientInstrumenterFactory.create(this.openTelemetry, this.clientExtractorConfigurer, this.clientSpanNameExtractorConfigurer, this.clientAdditionalExtractors, this.captureExperimentalSpanAttributes, this.emitExperimentalHttpClientMetrics);
        Instrumenter<ServerWebExchange, ServerWebExchange> serverInstrumenter = this.buildServerInstrumenter();
        return new SpringWebfluxTelemetry(clientInstrumenter, serverInstrumenter, this.openTelemetry.getPropagators());
    }

    private Instrumenter<ServerWebExchange, ServerWebExchange> buildServerInstrumenter() {
        WebfluxServerHttpAttributesGetter getter = WebfluxServerHttpAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)this.httpServerSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)getter)).addAttributesExtractor(this.httpServerAttributesExtractorBuilder.build()).addAttributesExtractors(this.serverAdditionalExtractors).addContextCustomizer(this.httpServerRouteBuilder.build()).addOperationMetrics(HttpServerMetrics.get());
        if (this.emitExperimentalHttpServerMetrics) {
            builder.addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        return builder.buildServerInstrumenter((TextMapGetter)WebfluxTextMapGetter.INSTANCE);
    }
}

