/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxServerHttpAttributesGetter;
import org.reactivestreams.Subscription;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

final class TelemetryProducingWebFilter
implements WebFilter,
Ordered {
    private final Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter;

    TelemetryProducingWebFilter(Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter) {
        this.instrumenter = instrumenter;
    }

    @NonNull
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Context parentContext = Context.current();
        Mono source = chain.filter(exchange);
        return new TelemetryWrappedMono((Mono<Void>)source, this.instrumenter, parentContext, exchange);
    }

    public int getOrder() {
        return -2147483647;
    }

    private static class TelemetryWrappedMono
    extends Mono<Void> {
        private final Mono<Void> source;
        private final Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter;
        private final Context parentContext;
        private final ServerWebExchange exchange;

        TelemetryWrappedMono(Mono<Void> source, Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter, Context parentContext, ServerWebExchange exchange) {
            this.source = source;
            this.instrumenter = instrumenter;
            this.parentContext = parentContext;
            this.exchange = exchange;
        }

        public void subscribe(CoreSubscriber<? super Void> actual) {
            if (!this.instrumenter.shouldStart(this.parentContext, (Object)this.exchange)) {
                this.source.subscribe(actual);
                return;
            }
            Context currentContext = this.instrumenter.start(this.parentContext, (Object)this.exchange);
            try (Scope ignored = currentContext.makeCurrent();){
                this.source.subscribe((CoreSubscriber)new TelemetryWrappedSubscriber(actual, currentContext, this.instrumenter, this.exchange));
            }
        }
    }

    private static class TelemetryWrappedSubscriber
    implements CoreSubscriber<Void> {
        private final CoreSubscriber<? super Void> actual;
        private final Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter;
        private final Context currentOtelContext;
        private final ServerWebExchange exchange;

        TelemetryWrappedSubscriber(CoreSubscriber<? super Void> actual, Context currentOtelContext, Instrumenter<ServerWebExchange, ServerWebExchange> instrumenter, ServerWebExchange exchange) {
            this.actual = actual;
            this.instrumenter = instrumenter;
            this.currentOtelContext = currentOtelContext;
            this.exchange = exchange;
        }

        public reactor.util.context.Context currentContext() {
            return this.actual.currentContext();
        }

        public void onSubscribe(Subscription s) {
            this.actual.onSubscribe(s);
        }

        public void onNext(Void unused) {
        }

        public void onError(Throwable t) {
            this.onTerminal(this.currentOtelContext, t);
            this.actual.onError(t);
        }

        public void onComplete() {
            this.onTerminal(this.currentOtelContext, null);
            this.actual.onComplete();
        }

        private void onTerminal(Context currentContext, Throwable t) {
            ServerHttpResponse response = this.exchange.getResponse();
            if (response.isCommitted()) {
                this.end(currentContext, t);
            } else {
                response.beforeCommit(() -> {
                    this.end(currentContext, t);
                    return Mono.empty();
                });
            }
        }

        private void end(Context currentContext, Throwable t) {
            HttpServerRoute.update((Context)currentContext, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, (context, exchange) -> WebfluxServerHttpAttributesGetter.INSTANCE.getHttpRoute((ServerWebExchange)exchange), (Object)this.exchange);
            this.instrumenter.end(currentContext, (Object)this.exchange, (Object)this.exchange, t);
        }
    }
}

