/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientHttpAttributesGetter;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public final class ClientInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";

    public static Instrumenter<ClientRequest, ClientResponse> create(OpenTelemetry openTelemetry, Consumer<HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse>> extractorConfigurer, Consumer<HttpSpanNameExtractorBuilder<ClientRequest>> spanNameExtractorConfigurer, List<AttributesExtractor<ClientRequest, ClientResponse>> additionalExtractors, boolean captureExperimentalSpanAttributes, boolean emitExperimentalHttpClientMetrics) {
        WebClientHttpAttributesGetter httpAttributesGetter = WebClientHttpAttributesGetter.INSTANCE;
        HttpClientAttributesExtractorBuilder extractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept((HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse>)extractorBuilder);
        HttpSpanNameExtractorBuilder httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        spanNameExtractorConfigurer.accept((HttpSpanNameExtractorBuilder<ClientRequest>)httpSpanNameExtractorBuilder);
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)httpSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(extractorBuilder.build()).addAttributesExtractors(additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (captureExperimentalSpanAttributes) {
            clientBuilder.addAttributesExtractor((AttributesExtractor)new WebClientExperimentalAttributesExtractor());
        }
        if (emitExperimentalHttpClientMetrics) {
            clientBuilder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return clientBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private ClientInstrumenterFactory() {
    }
}

