/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxServerTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxServerHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxTextMapGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.Experimental;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.SpringWebfluxBuilderUtil;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.web.server.ServerWebExchange;

public final class SpringWebfluxServerTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";
    private final DefaultHttpServerInstrumenterBuilder<ServerWebExchange, ServerWebExchange> builder;

    SpringWebfluxServerTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = DefaultHttpServerInstrumenterBuilder.create((String)INSTRUMENTATION_NAME, (OpenTelemetry)openTelemetry, (HttpServerAttributesGetter)WebfluxServerHttpAttributesGetter.INSTANCE, (TextMapGetter)WebfluxTextMapGetter.INSTANCE);
    }

    @CanIgnoreReturnValue
    public SpringWebfluxServerTelemetryBuilder addAttributesExtractor(AttributesExtractor<ServerWebExchange, ServerWebExchange> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxServerTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxServerTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxServerTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxServerTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super ServerWebExchange>, ? extends SpanNameExtractor<? super ServerWebExchange>> serverSpanNameExtractor) {
        this.builder.setSpanNameExtractor(serverSpanNameExtractor);
        return this;
    }

    public SpringWebfluxServerTelemetry build() {
        return new SpringWebfluxServerTelemetry((Instrumenter<ServerWebExchange, ServerWebExchange>)this.builder.build());
    }

    static {
        SpringWebfluxBuilderUtil.setServerBuilderExtractor(builder -> builder.builder);
        Experimental.internalSetEmitExperimentalServerTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpServerMetrics(emit.booleanValue()));
    }
}

