/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxClientTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.Experimental;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.SpringWebfluxBuilderUtil;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientHttpAttributesGetter;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public final class SpringWebfluxClientTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";
    private final DefaultHttpClientInstrumenterBuilder<ClientRequest, ClientResponse> builder;
    private final OpenTelemetry openTelemetry;

    SpringWebfluxClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = DefaultHttpClientInstrumenterBuilder.create((String)INSTRUMENTATION_NAME, (OpenTelemetry)openTelemetry, (HttpClientAttributesGetter)WebClientHttpAttributesGetter.INSTANCE);
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxClientTelemetryBuilder addAttributesExtractor(AttributesExtractor<ClientRequest, ClientResponse> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxClientTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxClientTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxClientTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxClientTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<ClientRequest>, SpanNameExtractor<ClientRequest>> clientSpanNameExtractor) {
        this.builder.setSpanNameExtractor(clientSpanNameExtractor);
        return this;
    }

    public SpringWebfluxClientTelemetry build() {
        return new SpringWebfluxClientTelemetry((Instrumenter<ClientRequest, ClientResponse>)this.builder.build(), this.openTelemetry.getPropagators());
    }

    static {
        SpringWebfluxBuilderUtil.setClientBuilderExtractor(builder -> builder.builder);
        Experimental.internalSetEmitExperimentalClientTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpClientMetrics(emit.booleanValue()));
    }
}

