/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientHttpAttributesGetter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public final class ClientInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";

    public static Instrumenter<ClientRequest, ClientResponse> create(OpenTelemetry openTelemetry, Consumer<HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse>> extractorConfigurer, Consumer<HttpSpanNameExtractorBuilder<ClientRequest>> spanNameExtractorConfigurer, Function<SpanNameExtractor<ClientRequest>, ? extends SpanNameExtractor<? super ClientRequest>> spanNameExtractorTransformer, List<AttributesExtractor<ClientRequest, ClientResponse>> additionalExtractors, boolean emitExperimentalHttpClientTelemetry) {
        WebClientHttpAttributesGetter httpAttributesGetter = WebClientHttpAttributesGetter.INSTANCE;
        HttpClientAttributesExtractorBuilder extractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept((HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse>)extractorBuilder);
        HttpSpanNameExtractorBuilder httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        spanNameExtractorConfigurer.accept((HttpSpanNameExtractorBuilder<ClientRequest>)httpSpanNameExtractorBuilder);
        SpanNameExtractor<? super ClientRequest> spanNameExtractor = spanNameExtractorTransformer.apply((SpanNameExtractor<ClientRequest>)httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(extractorBuilder.build()).addAttributesExtractors(additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (emitExperimentalHttpClientTelemetry) {
            clientBuilder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return clientBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private ClientInstrumenterFactory() {
    }
}

