/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetryBuilder;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.TelemetryProducingWebFilter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientTracingFilter;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;

public final class SpringWebfluxTelemetry {
    private final Instrumenter<ServerWebExchange, ServerWebExchange> serverInstrumenter;
    private final Instrumenter<ClientRequest, ClientResponse> clientInstrumenter;
    private final ContextPropagators propagators;

    public static SpringWebfluxTelemetry create(OpenTelemetry openTelemetry) {
        return SpringWebfluxTelemetry.builder(openTelemetry).build();
    }

    public static SpringWebfluxTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new SpringWebfluxTelemetryBuilder(openTelemetry);
    }

    SpringWebfluxTelemetry(Instrumenter<ClientRequest, ClientResponse> clientInstrumenter, Instrumenter<ServerWebExchange, ServerWebExchange> serverInstrumenter, ContextPropagators propagators) {
        this.clientInstrumenter = clientInstrumenter;
        this.serverInstrumenter = serverInstrumenter;
        this.propagators = propagators;
    }

    public void addClientTracingFilter(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        for (ExchangeFilterFunction filterFunction : exchangeFilterFunctions) {
            if (!(filterFunction instanceof WebClientTracingFilter)) continue;
            return;
        }
        exchangeFilterFunctions.add(new WebClientTracingFilter(this.clientInstrumenter, this.propagators));
    }

    public WebFilter createWebFilter() {
        return new TelemetryProducingWebFilter(this.serverInstrumenter);
    }

    public WebFilter createWebFilterAndRegisterReactorHook() {
        SpringWebfluxTelemetry.registerReactorHook();
        return this.createWebFilter();
    }

    private static void registerReactorHook() {
        ContextPropagationOperator.builder().build().registerOnEachOperator();
    }
}

