/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.tracer.HttpServerTracer;
import io.opentelemetry.instrumentation.servlet.HttpServletRequestGetter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class SpringWebMvcServerTracer
extends HttpServerTracer<HttpServletRequest, HttpServletResponse, HttpServletRequest, HttpServletRequest> {
    public SpringWebMvcServerTracer(Tracer tracer) {
        super(tracer);
    }

    protected Integer peerPort(HttpServletRequest request) {
        return request.getRemotePort();
    }

    protected String peerHostIP(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    protected TextMapPropagator.Getter<HttpServletRequest> getGetter() {
        return HttpServletRequestGetter.GETTER;
    }

    protected String url(HttpServletRequest request) {
        return request.getRequestURI();
    }

    protected String method(HttpServletRequest request) {
        return request.getMethod();
    }

    protected String requestHeader(HttpServletRequest httpServletRequest, String name) {
        return httpServletRequest.getHeader(name);
    }

    protected int responseStatus(HttpServletResponse httpServletResponse) {
        return httpServletResponse.getStatus();
    }

    protected void attachServerContext(Context context, HttpServletRequest request) {
        request.setAttribute(CONTEXT_ATTRIBUTE, (Object)context);
    }

    protected String flavor(HttpServletRequest connection, HttpServletRequest request) {
        return connection.getProtocol();
    }

    public Context getServerContext(HttpServletRequest request) {
        Object context = request.getAttribute(CONTEXT_ATTRIBUTE);
        return context instanceof Context ? (Context)context : null;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.spring-webmvc";
    }
}

