/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcServerTracer;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebMvcTracingFilter
extends OncePerRequestFilter
implements Ordered {
    private static final String FILTER_CLASS = "WebMVCTracingFilter";
    private static final String FILTER_METHOD = "doFilterInternal";
    private final SpringWebMvcServerTracer tracer;

    public WebMvcTracingFilter(OpenTelemetry openTelemetry) {
        this.tracer = new SpringWebMvcServerTracer(openTelemetry);
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Context ctx = this.tracer.startSpan(request, request, request, "WebMVCTracingFilter.doFilterInternal");
        try (Scope ignored = ctx.makeCurrent();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.tracer.end(ctx, response);
        }
        catch (Throwable t) {
            this.tracer.endExceptionally(ctx, t, response);
            throw t;
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return -2147483647;
    }
}

