/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class SpringWebMvcHttpAttributesExtractor
extends HttpServerAttributesExtractor<HttpServletRequest, HttpServletResponse> {
    SpringWebMvcHttpAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        super(capturedHttpHeaders);
    }

    @Nullable
    protected String method(HttpServletRequest request) {
        return request.getMethod();
    }

    protected List<String> requestHeader(HttpServletRequest request, String name) {
        Enumeration headers = request.getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(headers);
    }

    @Nullable
    protected Long requestContentLength(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return null;
    }

    @Nullable
    protected Long requestContentLengthUncompressed(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return null;
    }

    @Nullable
    protected String flavor(HttpServletRequest request) {
        return request.getProtocol();
    }

    @Nullable
    protected Integer statusCode(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Nullable
    protected Long responseContentLength(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Nullable
    protected Long responseContentLengthUncompressed(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    protected List<String> responseHeader(HttpServletRequest request, HttpServletResponse response, String name) {
        Collection headers = response.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (headers instanceof List) {
            return (List)headers;
        }
        return new ArrayList<String>(headers);
    }

    @Nullable
    protected String target(HttpServletRequest request) {
        String target = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            target = target + "?" + queryString;
        }
        return target;
    }

    @Nullable
    protected String route(HttpServletRequest request) {
        return null;
    }

    @Nullable
    protected String scheme(HttpServletRequest request) {
        return request.getScheme();
    }

    @Nullable
    protected String serverName(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return null;
    }
}

