/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

final class WebMvcTracingFilter
extends OncePerRequestFilter
implements Ordered {
    private final Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter;

    WebMvcTracingFilter(Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            this.instrumenter.end(context, (Object)request, (Object)response, null);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)request, (Object)response, t);
            throw t;
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return -2147483647;
    }
}

