/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

enum SpringWebMvcHttpAttributesGetter implements HttpServerAttributesGetter<HttpServletRequest, HttpServletResponse>
{
    INSTANCE;


    @Nullable
    public String method(HttpServletRequest request) {
        return request.getMethod();
    }

    public List<String> requestHeader(HttpServletRequest request, String name) {
        Enumeration headers = request.getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(headers);
    }

    @Nullable
    public Long requestContentLength(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return null;
    }

    @Nullable
    public Long requestContentLengthUncompressed(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return null;
    }

    @Nullable
    public String flavor(HttpServletRequest request) {
        return request.getProtocol();
    }

    @Nullable
    public Integer statusCode(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Nullable
    public Long responseContentLength(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Nullable
    public Long responseContentLengthUncompressed(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public List<String> responseHeader(HttpServletRequest request, HttpServletResponse response, String name) {
        Collection headers = response.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (headers instanceof List) {
            return (List)headers;
        }
        return new ArrayList<String>(headers);
    }

    @Nullable
    public String target(HttpServletRequest request) {
        String target = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            target = target + "?" + queryString;
        }
        return target;
    }

    @Nullable
    public String route(HttpServletRequest request) {
        return null;
    }

    @Nullable
    public String scheme(HttpServletRequest request) {
        return request.getScheme();
    }

    @Nullable
    public String serverName(HttpServletRequest request) {
        return null;
    }
}

