/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcNetAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcTracing;
import io.opentelemetry.instrumentation.spring.webmvc.StatusCodeExtractor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTracingBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-3.1";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private final HttpServerAttributesExtractorBuilder<HttpServletRequest, HttpServletResponse> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);

    SpringWebMvcTracingBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public SpringWebMvcTracingBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @Deprecated
    public SpringWebMvcTracingBuilder captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.httpAttributesExtractorBuilder.captureHttpHeaders(capturedHttpHeaders);
        return this;
    }

    public SpringWebMvcTracingBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    public SpringWebMvcTracingBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public SpringWebMvcTracing build() {
        SpringWebMvcHttpAttributesGetter httpAttributesGetter = SpringWebMvcHttpAttributesGetter.INSTANCE;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)this.httpAttributesExtractorBuilder.build()).addAttributesExtractor((AttributesExtractor)new StatusCodeExtractor()).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)new SpringWebMvcNetAttributesGetter())).addAttributesExtractors(this.additionalExtractors).addRequestMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.get()).newServerInstrumenter((TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE);
        return new SpringWebMvcTracing((Instrumenter<HttpServletRequest, HttpServletResponse>)instrumenter);
    }
}

