/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class StatusCodeExtractor
implements AttributesExtractor<HttpServletRequest, HttpServletResponse> {
    StatusCodeExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, HttpServletRequest httpServletRequest) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, HttpServletRequest httpServletRequest, @Nullable HttpServletResponse response, @Nullable Throwable error) {
        if (response != null) {
            long statusCode = !response.isCommitted() && error != null ? 500L : (long)response.getStatus();
            attributes.put(SemanticAttributes.HTTP_STATUS_CODE, (Object)statusCode);
        }
    }
}

