/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.servlet.javax.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcHttpAttributesExtractor;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcNetAttributesExtractor;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcTracing;
import io.opentelemetry.instrumentation.spring.webmvc.StatusCodeExtractor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTracingBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-3.1";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.server((Config)Config.get());

    SpringWebMvcTracingBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public SpringWebMvcTracingBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    public SpringWebMvcTracingBuilder captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public SpringWebMvcTracing build() {
        SpringWebMvcHttpAttributesExtractor httpAttributesExtractor = new SpringWebMvcHttpAttributesExtractor(this.capturedHttpHeaders);
        Instrumenter instrumenter = Instrumenter.newBuilder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpCommonAttributesExtractor)httpAttributesExtractor)).addAttributesExtractor((AttributesExtractor)httpAttributesExtractor).addAttributesExtractor((AttributesExtractor)new StatusCodeExtractor()).addAttributesExtractor((AttributesExtractor)new SpringWebMvcNetAttributesExtractor()).addAttributesExtractors(this.additionalExtractors).addRequestMetrics(HttpServerMetrics.get()).newServerInstrumenter((TextMapGetter)JavaxHttpServletRequestGetter.GETTER);
        return new SpringWebMvcTracing((Instrumenter<HttpServletRequest, HttpServletResponse>)instrumenter);
    }
}

