/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.ServletRequestPathUtils;

final class HttpRouteSupport {
    private final AtomicBoolean contextRefreshTriggered = new AtomicBoolean();
    @Nullable
    private volatile DispatcherServlet dispatcherServlet;
    @Nullable
    private volatile List<HandlerMapping> handlerMappings;
    private volatile boolean parseRequestPath;

    HttpRouteSupport() {
    }

    void onFilterInit(FilterConfig filterConfig) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        if (!(context instanceof ConfigurableWebApplicationContext)) {
            return;
        }
        DispatcherServlet servlet = (DispatcherServlet)context.getBeanProvider(DispatcherServlet.class).getIfAvailable();
        if (servlet != null) {
            this.dispatcherServlet = servlet;
            ((ConfigurableWebApplicationContext)context).addApplicationListener((ApplicationListener)new WebContextRefreshListener());
        }
    }

    boolean hasMappings() {
        if (this.contextRefreshTriggered.compareAndSet(true, false)) {
            Optional.ofNullable(this.dispatcherServlet).map(DispatcherServlet::getHandlerMappings).ifPresent(this::setHandlerMappings);
        }
        return this.handlerMappings != null;
    }

    private void setHandlerMappings(List<HandlerMapping> mappings) {
        ArrayList<HandlerMapping> handlerMappings = new ArrayList<HandlerMapping>();
        for (HandlerMapping mapping : mappings) {
            if (!(mapping instanceof RequestMappingHandlerMapping)) continue;
            handlerMappings.add(mapping);
            if (!mapping.usesPathPatterns()) continue;
            this.parseRequestPath = true;
        }
        if (!handlerMappings.isEmpty()) {
            this.handlerMappings = handlerMappings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getHttpRoute(Context context, HttpServletRequest request) {
        boolean parsePath = this.parseRequestPath;
        Object previousValue = null;
        if (parsePath) {
            previousValue = request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
            ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
        }
        try {
            Object bestMatchingPattern;
            if (this.findMapping(request) && (bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)) != null) {
                String string = HttpRouteSupport.prependContextPath(request, bestMatchingPattern.toString());
                return string;
            }
        }
        finally {
            if (parsePath) {
                if (previousValue == null) {
                    request.removeAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
                } else {
                    request.setAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE, previousValue);
                }
            }
        }
        return null;
    }

    private boolean findMapping(HttpServletRequest request) {
        try {
            for (HandlerMapping mapping : Objects.requireNonNull(this.handlerMappings)) {
                HandlerExecutionChain handler = mapping.getHandler(request);
                if (handler == null) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String prependContextPath(HttpServletRequest request, String route) {
        String contextPath = request.getContextPath();
        if (contextPath == null) {
            return route;
        }
        return contextPath + (route.startsWith("/") ? route : "/" + route);
    }

    final class WebContextRefreshListener
    implements ApplicationListener<ContextRefreshedEvent> {
        WebContextRefreshListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            HttpRouteSupport.this.contextRefreshTriggered.set(true);
        }
    }
}

