/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcNetAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcTelemetry;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-5.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private final HttpServerAttributesExtractorBuilder<HttpServletRequest, HttpServletResponse> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE, (NetServerAttributesGetter)SpringWebMvcNetAttributesGetter.INSTANCE);

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public SpringWebMvcTelemetry build() {
        SpringWebMvcHttpAttributesGetter httpAttributesGetter = SpringWebMvcHttpAttributesGetter.INSTANCE;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.get()).buildServerInstrumenter((TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE);
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)instrumenter);
    }
}

