/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

enum SpringWebMvcHttpAttributesGetter implements HttpServerAttributesGetter<HttpServletRequest, HttpServletResponse>
{
    INSTANCE;


    @Nullable
    public String getMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public List<String> getRequestHeader(HttpServletRequest request, String name) {
        Enumeration headers = request.getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(headers);
    }

    @Nullable
    public String getFlavor(HttpServletRequest request) {
        String flavor = request.getProtocol();
        if (flavor == null) {
            return null;
        }
        if (flavor.startsWith("HTTP/")) {
            flavor = flavor.substring("HTTP/".length());
        }
        return flavor;
    }

    public Integer getStatusCode(HttpServletRequest request, HttpServletResponse response, @Nullable Throwable error) {
        int statusCode = !response.isCommitted() && error != null ? 500 : response.getStatus();
        return statusCode;
    }

    public List<String> getResponseHeader(HttpServletRequest request, HttpServletResponse response, String name) {
        Collection headers = response.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (headers instanceof List) {
            return (List)headers;
        }
        return new ArrayList<String>(headers);
    }

    @Nullable
    public String getTarget(HttpServletRequest request) {
        String target = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            target = target + "?" + queryString;
        }
        return target;
    }

    @Nullable
    public String getScheme(HttpServletRequest request) {
        return request.getScheme();
    }
}

