/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteSource;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.HttpRouteSupport;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

final class WebMvcTelemetryProducingFilter
extends OncePerRequestFilter
implements Ordered {
    private final Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter;
    private final HttpRouteSupport httpRouteSupport = new HttpRouteSupport();

    WebMvcTelemetryProducingFilter(Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void afterPropertiesSet() {
    }

    protected void initFilterBean() {
        this.httpRouteSupport.onFilterInit(Objects.requireNonNull(this.getFilterConfig()));
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        Throwable error = null;
        try (Scope ignored = context.makeCurrent();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (this.httpRouteSupport.hasMappings()) {
                HttpRouteHolder.updateHttpRoute((Context)context, (HttpRouteSource)HttpRouteSource.CONTROLLER, this.httpRouteSupport::getHttpRoute, (Object)request);
            }
            this.instrumenter.end(context, (Object)request, (Object)response, error);
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return -2147483647;
    }
}

