/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

enum SpringWebMvcHttpAttributesGetter implements HttpServerAttributesGetter<HttpServletRequest, HttpServletResponse>
{
    INSTANCE;


    @Nullable
    public String getHttpRequestMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public List<String> getHttpRequestHeader(HttpServletRequest request, String name) {
        Enumeration headers = request.getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(headers);
    }

    public Integer getHttpResponseStatusCode(HttpServletRequest request, HttpServletResponse response, @Nullable Throwable error) {
        int statusCode = !response.isCommitted() && error != null ? 500 : response.getStatus();
        return statusCode;
    }

    public List<String> getHttpResponseHeader(HttpServletRequest request, HttpServletResponse response, String name) {
        Collection headers = response.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (headers instanceof List) {
            return (List)headers;
        }
        return new ArrayList<String>(headers);
    }

    @Nullable
    public String getUrlScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    @Nullable
    public String getUrlPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    @Nullable
    public String getUrlQuery(HttpServletRequest request) {
        return request.getQueryString();
    }
}

