/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcTelemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-5.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private final HttpServerAttributesExtractorBuilder<HttpServletRequest, HttpServletResponse> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    @Nullable
    private Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractorTransformer;

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractor) {
        this.spanNameExtractorTransformer = spanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    public SpringWebMvcTelemetry build() {
        SpanNameExtractor<? super HttpServletRequest> originalSpanNameExtractor;
        SpringWebMvcHttpAttributesGetter httpAttributesGetter = SpringWebMvcHttpAttributesGetter.INSTANCE;
        SpanNameExtractor<? super HttpServletRequest> spanNameExtractor = originalSpanNameExtractor = HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter);
        if (this.spanNameExtractorTransformer != null) {
            spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<HttpServletRequest>)originalSpanNameExtractor);
        }
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.create((HttpServerAttributesGetter)httpAttributesGetter)).buildServerInstrumenter((TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE);
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)instrumenter);
    }
}

