/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcTelemetry;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.internal.Experimental;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.internal.SpringMvcBuilderUtil;
import java.util.Collection;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-5.3";
    private final DefaultHttpServerInstrumenterBuilder<HttpServletRequest, HttpServletResponse> builder;

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = DefaultHttpServerInstrumenterBuilder.create((String)INSTRUMENTATION_NAME, (OpenTelemetry)openTelemetry, (HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE, (TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE);
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpServletRequest>, SpanNameExtractor<HttpServletRequest>> spanNameExtractor) {
        this.builder.setSpanNameExtractor(spanNameExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.builder.setEmitExperimentalHttpServerMetrics(emitExperimentalHttpServerMetrics);
        return this;
    }

    public SpringWebMvcTelemetry build() {
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)this.builder.build());
    }

    static {
        SpringMvcBuilderUtil.setBuilderExtractor(builder -> builder.builder);
        Experimental.internalSetEmitExperimentalTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpServerMetrics(emit.booleanValue()));
    }
}

