/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcTelemetry;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.internal.SpringMvcBuilderUtil;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-5.3";
    private final DefaultHttpServerInstrumenterBuilder<HttpServletRequest, HttpServletResponse> builder;

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = new DefaultHttpServerInstrumenterBuilder(INSTRUMENTATION_NAME, openTelemetry, (HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE).setHeaderGetter((TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE);
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractor) {
        this.builder.setSpanNameExtractor(spanNameExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.builder.setEmitExperimentalHttpServerMetrics(emitExperimentalHttpServerMetrics);
        return this;
    }

    public SpringWebMvcTelemetry build() {
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)this.builder.build());
    }

    public DefaultHttpServerInstrumenterBuilder<HttpServletRequest, HttpServletResponse> getBuilder() {
        return this.builder;
    }

    static {
        SpringMvcBuilderUtil.setBuilderExtractor(SpringWebMvcTelemetryBuilder::getBuilder);
    }
}

