/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v6_0;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;

enum SpringWebMvcHttpAttributesGetter implements HttpServerAttributesGetter<HttpServletRequest, HttpServletResponse>
{
    INSTANCE;


    @Nullable
    public String getHttpRequestMethod(HttpServletRequest request) {
        return request.getMethod();
    }

    public List<String> getHttpRequestHeader(HttpServletRequest request, String name) {
        Enumeration headers = request.getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(headers);
    }

    public Integer getHttpResponseStatusCode(HttpServletRequest request, HttpServletResponse response, @Nullable Throwable error) {
        int statusCode = !response.isCommitted() && error != null ? 500 : response.getStatus();
        return statusCode;
    }

    public List<String> getHttpResponseHeader(HttpServletRequest request, HttpServletResponse response, String name) {
        Collection headers = response.getHeaders(name);
        if (headers == null) {
            return Collections.emptyList();
        }
        if (headers instanceof List) {
            return (List)headers;
        }
        return new ArrayList<String>(headers);
    }

    @Nullable
    public String getUrlScheme(HttpServletRequest request) {
        return request.getScheme();
    }

    @Nullable
    public String getUrlPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    @Nullable
    public String getUrlQuery(HttpServletRequest request) {
        return request.getQueryString();
    }

    @Nullable
    public String getNetworkProtocolName(HttpServletRequest request, @Nullable HttpServletResponse response) {
        String protocol = request.getProtocol();
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return "http";
        }
        return null;
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpServletRequest request, @Nullable HttpServletResponse response) {
        String protocol = request.getProtocol();
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return protocol.substring("HTTP/".length());
        }
        return null;
    }

    @Nullable
    public String getServerAddress(HttpServletRequest request) {
        return request.getServerName();
    }

    public Integer getServerPort(HttpServletRequest request) {
        return request.getServerPort();
    }

    @Nullable
    public String getClientSocketAddress(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return request.getRemoteAddr();
    }

    public Integer getClientSocketPort(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return request.getRemotePort();
    }

    @Nullable
    public String getServerSocketAddress(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return request.getLocalAddr();
    }

    public Integer getServerSocketPort(HttpServletRequest request, @Nullable HttpServletResponse response) {
        return request.getLocalPort();
    }
}

