/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v6_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRouteSource;
import io.opentelemetry.instrumentation.spring.webmvc.v6_0.HttpRouteSupport;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

final class WebMvcTelemetryProducingFilter
extends OncePerRequestFilter
implements Ordered {
    private final Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter;
    private final HttpRouteSupport httpRouteSupport = new HttpRouteSupport();

    WebMvcTelemetryProducingFilter(Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void afterPropertiesSet() {
    }

    protected void initFilterBean() {
        this.httpRouteSupport.onFilterInit(Objects.requireNonNull(this.getFilterConfig()));
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        Throwable error = null;
        try (Scope ignored = context.makeCurrent();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (this.httpRouteSupport.hasMappings()) {
                HttpServerRoute.update((Context)context, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, this.httpRouteSupport::getHttpRoute, (Object)request);
            }
            this.instrumenter.end(context, (Object)request, (Object)response, error);
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return -2147483647;
    }
}

